import {
  defineConfig
} from 'vite'
import {
  createVuePlugin
} from 'vite-plugin-vue2'
import {
  viteCommonjs
} from '@originjs/vite-plugin-commonjs' // 让浏览器支持commonjs语法
import legacyPlugin from '@vitejs/plugin-legacy'
import path from 'path'
export default defineConfig(() => {
  return {
    base: './',
    plugins: [
      createVuePlugin(),
      viteCommonjs(),
      legacyPlugin({
        targets: ['chrome 52'], // 需要兼容的目标列表，可以设置多�?        additionalLegacyPolyfills: ['regenerator-runtime/runtime'] // 面向IE11时需要此插件
      })
    ],
    server: {
      // host: '0.0.0.0',
      // port: 8088,
      open: false,
      disableHostCheck: true,
      proxy: {
        // '^/wsppip/(yh|cd)': {
        //   // target: 'https://house.vipfww.com',
        //   target: 'http://121.5.131.76',
        //   logLevel: 'debug',
        //   ws: true,
        //   changeOrigin: true,
        //   rewrite: (path) => path.replace(/^\/wsppip/, '/gwkyep')
        // },
        '/wsppip': {
          // target: 'https://house.vipfww.com',
          // target: 'https://3x929684m3.oicp.vip',
          target: 'http://127.0.0.1:8088',
          logLevel: 'debug',
          ws: false,
          changeOrigin: true,
          rewrite: (path) => path.replace(/^\/wsppip/, '/gwkyep')
        },
        // 写的图片代理路径
        '/fileservice': {
          target: 'https://house.vipfww.com',
          changeOrigin: true
        }
      }
    },
    // 解决element图标与sass冲突问题
    css: {
      // css预设器配置项
      loaderOptions: {
        sass: {
          implementation: require('sass'),
          sassOptions: {
            // 生效代码
            outputStyle: 'expanded'
          }
        }
      }
    },
    resolve: {
      /** 添加alias规则 */
      alias: [{
          find: '@',
          replacement: path.resolve(__dirname, 'src')
        },
        {
          find: '/@',
          replacement: 'src'
        }
      ],
      extensions: ['.vue', '.js', '.json']
    }
  }
})
