import { Login, Register, sendMail, Logout, GetInfo, getAnByQxbs } from '@/api/api'
import { getToken, setToken, removeToken, setCasual, removeCasual, getCasual } from '@/utils/auth'
import router, { resetRouter } from '@/router'
import { generatekey } from '@/utils/rsaEncrypt'
import { setCurrencyToken, removeCurrencyToken } from '@/utils/currencyCookie'
import { Message } from 'element-ui'

const state = {
  token: getToken(),
  casual: getCasual(),
  name: '',
  avatar: '',
  introduction: '',
  roles: [],
  buttonRoles: []
}

const mutations = {
  SET_DATA: (state, data) => {
    state.data = data
  },
  SET_TOKEN: (state, token) => {
    state.token = token
  },
  SET_INTRODUCTION: (state, introduction) => {
    state.introduction = introduction
  },
  SET_NAME: (state, name) => {
    state.name = name
  },
  SET_AVATAR: (state, avatar) => {
    state.avatar = avatar
  },
  SET_ROLES: (state, roles) => {
    state.roles = roles
  },
  SET_CASUAL: (state, casual) => {
    state.casual = casual
  },
  SET_BUTTONROLES: (state, buttonRoles) => {
    state.buttonRoles = buttonRoles
  },
  SET_SYSTEM: (state, switchingSystem) => {
    state.switchingSystem = switchingSystem
  }
}
const actions = {
  // user login
  login({ commit }, userInfo) {
    const { username, password } = userInfo
    return new Promise((resolve, reject) => {
      Login({ yhzh: username.trim(), yhmm: password }).then(response => {
        const { data } = response
        console.log(data);
        if (data.shzt === 0) {
          Message.error('注册账号未审核, 请等待管理员审核')
          throw '注册账号未审核'
        }
        if (data) {
          commit('SET_TOKEN', data.token)
          console.log(data.token,"data.token");
          setToken(data.token)
        }
        resolve(response)
      }).catch(error => {
        reject(error)
      })
    })
  },
  register({ commit }, userInfo) {
    return new Promise((resolve, reject) => {
      Register(userInfo).then(async response => {
        await sendMail('670542818@qq.com', '有新用户注册', '有新用户注册，请管理员审核', false)
        resolve(response)
      }).catch(error => {
        reject(error)
      })
    })
  },

  // get user info
  getInfo({ commit, state }) {
    return new Promise((resolve, reject) => {
      GetInfo(state.token).then(response => {
        console.log(response);
        if (!response) {
          reject('验证失败, 请重新登陆了！')
        }
        // const { roles, introduction } = response
        // roles must be a non-empty array
        // if (!roles || roles.length <= 0) {
        //   reject('暂无权限!')
        // }
        /* this.$notify.success({
          title: '登录成功',
          message: '欢迎您回来！',
          duration: 3000
        })*/
        const roles = ["admin"]
        const modules = import.meta.globEager('@/assets/index/*.png')
        commit('SET_DATA', response)
        commit('SET_ROLES', roles)
        commit('SET_NAME', response.yhxm)
        commit('SET_AVATAR', modules['/src/assets/index/head.png'].default)
        // commit('SET_INTRODUCTION', introduction)
        resolve(response)
      }).catch(error => {
        console.log(error)
        reject(error)
      })
    })
  },

  // user logout
  logout({ commit, state, dispatch }) {
    return new Promise((resolve, reject) => {
      Logout(state.token).then(() => {
        commit('SET_TOKEN', '')
        commit('SET_ROLES', [])
        commit('SET_CASUAL', [])
        removeCurrencyToken('Apply-Token')
        removeToken()
        resetRouter()
        removeCasual()
        dispatch('tagsView/delAllViews', null, { root: true })
        resolve()
      }).catch(error => {
        reject(error)
      })
    })
  },

  // remove token
  resetToken({ commit }) {
    return new Promise(resolve => {
      commit('SET_TOKEN', '')
      commit('SET_ROLES', [])
      commit('SET_CASUAL', [])
      removeCurrencyToken('Apply-Token')
      removeToken()
      removeCasual()
      resolve()
    })
  },
  // dynamically modify permissions
  async changeRoles({ commit, dispatch }, role) {
    const token = role + '-token'

    commit('SET_TOKEN', token)
    setToken(token)

    const { roles } = await dispatch('getInfo')
    resetRouter()

    // generate accessible routes map based on roles
    const accessRoutes = await dispatch('permission/generateRoutes', roles, { root: true })
    // dynamically add accessible routes
    router.addRoutes(accessRoutes)

    // reset visited views and cached views
    dispatch('tagsView/delAllViews', null, { root: true })
  },
  async getButton({ commit, state, dispatch }, data) {
    return new Promise((resolve, reject) => {
      const item = state.buttonRoles.filter((item) => {
        return item[data] === data
      })
      if (item.length === 0) {
        getAnByQxbs({ qxbs: data }).then((res) => {
          const item = {}
          item[data] = res.data
          state.buttonRoles.push(item)
          resolve(res.data)
        })
      } else {
        resolve(item[data])
      }
    })
  },
  async switchSystem({ commit, state, dispatch }, data) {
    return new Promise((resolve, reject) => {
      const setCookie = setCurrencyToken('Apply-Token', data)
      resolve(setCookie)
    })
  }
}

export default {
  namespaced: true,
  state,
  mutations,
  actions
}
