import Cookies from 'js-cookie'

const state = {
  sidebar: {
    opened: Cookies.get('sidebarStatus') ? !!+Cookies.get('sidebarStatus') : true,
    withoutAnimation: false
  },
  device: 'desktop',
  size: Cookies.get('size') || 'medium',
  // url:'http://i8qnf3.natappfree.cc',
  // url: 'http://ws.vipfwww.com',
  // url: 'http://192.168.137.198:82',
  // url: window.location.href.split('/wsfep')[0] + '/api/ccb-chfep-wsupload/upload/cos/upload',
  // url: 'http://110.53.141.23:18081' + '/api/ccb-chfep-wsupload/upload/cos/upload',
  // url: 'http://localhost:82' + '/api/ccb-chfep-wsupload/upload/cos/upload',
  // url: `/api${import.meta.env.VITE_APP_SERVER_WSUPLOAD}/upload/cos/upload`,
  // baseUrl: 'https://chfepfile-1252378986.cos.ap-guangzhou.myqcloud.com',
  baseUrl: 'http://121.5.131.76/gwfile/wskyfile',
  kkfileUrl: 'http://127.0.0.1/file/onlinePreview?url=',
  // baseUrl: 'http://127.0.0.1/wsfiles/',
  // kkfileUrl: 'http://127.0.0.1/file/onlinePreview?url=',
  // baseUrl: 'http://111.229.91.157/wsfiles/',
  // kkfileUrl: 'http://111.229.91.157/file/onlinePreview?url=',

  ywbh: '', // 业务编号
  bgbh: '', // 变更编号
  backgroundColor: "transparent",
}

const mutations = {
  TOGGLE_SIDEBAR: state => {
    state.sidebar.opened = !state.sidebar.opened
    state.sidebar.withoutAnimation = false
    if (state.sidebar.opened) {
      Cookies.set('sidebarStatus', 1)
    } else {
      Cookies.set('sidebarStatus', 0)
    }
  },
  CLOSE_SIDEBAR: (state, withoutAnimation) => {
    Cookies.set('sidebarStatus', 0)
    state.sidebar.opened = false
    state.sidebar.withoutAnimation = withoutAnimation
  },
  TOGGLE_DEVICE: (state, device) => {
    state.device = device
  },
  SET_SIZE: (state, size) => {
    state.size = size
    Cookies.set('size', size)
  }
}

const actions = {
  toggleSideBar({ commit }) {
    commit('TOGGLE_SIDEBAR')
  },
  closeSideBar({ commit }, { withoutAnimation }) {
    commit('CLOSE_SIDEBAR', withoutAnimation)
  },
  toggleDevice({ commit }, device) {
    commit('TOGGLE_DEVICE', device)
  },
  setSize({ commit }, size) {
    commit('SET_SIZE', size)
  }
}

export default {
  namespaced: true,
  state,
  mutations,
  actions
}
