import Vue from 'vue'
import Router from 'vue-router'

Vue.use(Router)

/* Layout */
import Layout from '@/layout'

/* Router Modules */
/* import componentsRouter from './modules/components'
import chartsRouter from './modules/charts'
import nestedRouter from './modules/nested'
import tableRouter from './modules/table'*/

/**
 * Note: sub-menu only appear when route children.length >= 1
 * Detail see: https://panjiachen.github.io/vue-element-admin-site/guide/essentials/router-and-nav.html
 *
 * hidden: true                   if set true, item will not show in the sidebar(default is false)
 * alwaysShow: true               if set true, will always show the root menu
 *                                if not set alwaysShow, when item has more than one children route,
 *                                it will becomes nested mode, otherwise not show the root menu
 * redirect: noRedirect           if set noRedirect will no redirect in the breadcrumb
 * name:'router-name'             the name is used by <keep-alive> (must set!!!)
 * meta : {
    roles: ['admin','editor']    control the page roles (you can set multiple roles)
    title: 'title'               the name show in sidebar and breadcrumb (recommend set)
    icon: 'svg-name'/'el-icon-x' the icon show in the sidebar
    noCache: true                if set true, the page will no be cached(default is false)
    affix: true                  if set true, the tag will affix in the tags-view
    breadcrumb: false            if set false, the item will hidden in breadcrumb(default is true)
    activeMenu: '/example/list'  if set path, the sidebar will highlight the path you set
  }
 */

/**
 * constantRoutes
 * a base page that does not have permission requirements
 * all roles can be accessed
 */
export const constantRoutes = [
  {
    path: '/redirect',
    component: Layout,
    hidden: true,
    children: [
      {
        path: '/redirect/:path(.*)',
        component: () => import('@/views/redirect/index')
      }
    ]
  },
  {
    path: '/login',
    component: () => import('@/views/login/index'),
    hidden: true
  },
  {
    path: '/signup',
    component: () => import('@/views/login/register'),
    hidden: true
  },
  {
    path: '/',
    component: Layout,
    redirect: '/dashboard',
    children: [
      {
        path: 'dashboard',
        component: () => import('@/views/dashboard/index'),
        name: 'Dashboard',
        meta: { title: '首页', icon: 'el-icon-s-home', affix: true },
        hidden: true
      }
    ]
  },
  {
    path: '/auth-redirect',
    component: () => import('@/views/login/auth-redirect'),
    hidden: true
  },
  {
    path: '/404',
    component: () => import('@/views/error-page/404'),
    hidden: true
  },
  {
    path: '/401',
    component: () => import('@/views/error-page/401'),
    hidden: true
  },
  // {
  //   path: '/loginIndex',
  //   component: () => import('@/views/login/components/selectSystem'),
  //   hidden: true
  // },
  {
    path: '/gwIndex',
    component: () => import('@/views/website'),
    hidden: true,
    meta: {},
    redirect: '/home',
    children: [{
      path: '/project',
      component: () => import('@/views/website/project'),
    },
    {
      path: '/home',
      component: () => import('@/views/website/home'),
    },
    {
      path: '/information',
      component: () => import('@/views/website/information'),
      redirect: '/information/news',
      children: [{
        path: '/information/news',
        component: () => import('@/views/website/information/news'),
        hidden: true
      },
      {
        path: '/information/detail',
        component: () => import('@/views/website/information/detail'),
        hidden: true
      }
      ]
    },
    {
      path: '/achievement',
      component: () => import('@/views/website/achievement'),
    },
    {
      path: '/research',
      component: () => import('@/views/website/research'),
    },
    {
      path: '/research/detail',
      component: () => import('@/views/website/research/detail'),
      hidden: true
    },
    {
      path: '/project/detail',
      component: () => import('@/views/website/project/detail'),
      hidden: true
    }
    ]
  },
  // {
  //   path: '/rbac',
  //   component: Layout,
  //   meta: { title: '权限管理', icon: 'el-icon-key' },
  //   alwaysShow: true,
  //   children: [
  //     {
  //       path: 'user',
  //       component: () => import('@/views/system/user'),
  //       name: 'user',
  //       meta: { id: '1', title: '用户管理', noCache: true, icon: 'el-icon-user' }
  //     },
  //     {
  //       path: 'role',
  //       component: () => import('@/views/system/role'),
  //       name: 'role',
  //       meta: { id: '2', title: '角色管理', noCache: true, icon: 'el-icon-user-solid' }
  //     },
  //     {
  //       path: 'menu',
  //       component: () => import('@/views/system/menu'),
  //       name: 'menu',
  //       meta: { id: '2', title: '菜单管理', noCache: true, icon: 'el-icon-s-operation' }
  //     }
  //   ]
  // },
  // {
  //   path: '/background',
  //   component: Layout,
  //   meta: { title: '后台配置', icon: 'el-icon-setting' },
  //   alwaysShow: true,
  //   children: [
  //     {
  //       path: 'siteName',
  //       component: () => import('@/views/background/siteName'),
  //       name: 'siteName',
  //       meta: { id: '1', title: '网站名称配置', noCache: true, icon: 'el-icon-s-data' }
  //     },
  //     {
  //       path: 'announcement',
  //       component: () => import('@/views/background/announcement'),
  //       name: 'announcement',
  //       meta: { id: '2', title: '公告发布管理', noCache: true, icon: 'el-icon-s-promotion' }
  //     },
  //     {
  //       path: 'subjectToRelease',
  //       component: () => import('@/views/background/subjectToRelease'),
  //       name: 'subjectToRelease',
  //       meta: { id: '3', title: '课题发布管理', noCache: true, icon: 'el-icon-s-opportunity' }
  //     },
  //     {
  //       path: 'peopleManagement',
  //       component: () => import('@/views/background/peopleManagement'),
  //       name: 'peopleManagement',
  //       meta: { id: '4', title: '课题人员管理', noCache: true, icon: 'el-icon-s-order' }
  //     },
  //     {
  //       path: 'achievement',
  //       component: () => import('@/views/background/achievement'),
  //       name: 'achievement',
  //       meta: { id: '5', title: '成果展示', noCache: true, icon: 'el-icon-s-management' }
  //     }
  //   ]
  // }
]

/**
 * asyncRoutes
 * the routes that need to be dynamically loaded based on user roles
 */
export const asyncRoutes = [
  // 404页面必须放在最�?!!!
  { path: '*', redirect: '/404', hidden: true }
]

const createRouter = () => new Router({
  // mode: 'history', // require service support
  scrollBehavior: () => ({ y: 0 }),
  routes: constantRoutes
})

const router = createRouter()

// Detail see: https://github.com/vuejs/vue-router/issues/1234#issuecomment-357941465
export function resetRouter() {
  const newRouter = createRouter()
  router.matcher = newRouter.matcher // reset router
}

export default router
