import Vue from 'vue'

import Cookies from 'js-cookie'

import 'normalize.css/normalize.css' // a modern alternative to CSS resets
import Treeselect from '@riophae/vue-treeselect'
import '@riophae/vue-treeselect/dist/vue-treeselect.css'
import Element from 'element-ui'
import './styles/element-variables.scss'
// import enLang from 'element-ui/lib/locale/lang/en'// 如果使用中文语言包请默认支持，无需额外引入，请删除该依赖

import '@/styles/index.scss' // global css
import '@/styles/public.css'
import App from './App'
import store from './store'
import router from './router'

import './icons' // icon
import './permission' // permission control
import './utils/error-log' // error log
import './utils/rem.js'
import * as filters from './filters' // global filters
import { hasBtnPermission } from './store/modules/permission'
import { getSjzdbyZdbm, getButton } from './utils/listall'
import dragDialog from '@/components/Max-Dialog/dialog' // 引入移动事件（el-drag-dialog.js的内容为上面的代码块）
Vue.directive('v-dialogDrag', dragDialog)// 添加标签事件绑定 可以放大移动弹窗
// 弹窗默认点击遮罩改为不关闭 为了防止和拖拽冲突 ，这句需要放在use ElementUI之前（也可以不加这句，自己测试区别）
Element.Dialog.props.closeOnClickModal.default = false

Vue.use(Element, {
  size: Cookies.get('size') || 'mini' // set element-ui default size
  // locale: enLang // 如果使用中文，无需设置，请删除
})

// register global utility filters
Object.keys(filters).forEach(key => {
  Vue.filter(key, filters[key])
})
Vue.component('Treeselect', Treeselect)
Vue.config.productionTip = false
Vue.prototype.hasPerm = hasBtnPermission
Vue.prototype.getDict = getSjzdbyZdbm
Vue.prototype.getButton = getButton
new Vue({
  el: '#app',
  router,
  store,
  render: h => h(App)
})
