import PizZip from 'pizzip'
import JSZipUtils from 'jszip-utils'
import DocxTemplater from 'docxtemplater'

const generateDocxFile = function(template, fileData) {
  const _this = this
  const imgSize = { imgUrl: [300, 65], codeUrl: [200, 200] }
  // 这里要引入处理图片的插件
  var ImageModule = require('docxtemplater-image-module-free');
  const expressions = require('angular-expressions');
  JSZipUtils.getBinaryContent(template, function(error, content) {
    if (error) { throw error }
    expressions.filters.size = function(input, width, height) {
      return { data: input, size: [width, height] };
    }
    // 图片处理
    const opts = { centered: false };
    opts.getImage = chartId => { return _this.base64DataURLToArrayBuffer(chartId) };
    opts.getSize = function(img, tagValue, tagName) {
      if (imgSize.hasOwnProperty(tagName)) {
        return imgSize[tagName]
      } else {
        return [300, 60]
      }
    }
    // 创建一个PizZip实例，内容为模板的内容
    const zip = new PizZip(content)
    // 创建并加载docxtemplater实例对象
    const doc = new DocxTemplater()
    doc.attachModule(new ImageModule(opts))
    doc.loadZip(zip)
    doc.setData(fileData)
    try {
      // 用模板变量的值替换所有模板变量
      doc.render()
    } catch (error) {
      // 抛出异常
      const e = { message: error.message, name: error.name, stack: error.stack, properties: error.properties }
      console.log(JSON.stringify({ error: e }))
      throw error
    }
    // 生成一个代表docxtemplater对象的zip文件（不是一个真实的文件，而是在内存中的表示）
    const out = doc.getZip().generate({
      type: 'blob',
      mimeType: 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'
    })
    return out;
  })
}

export {
  generateDocxFile
}
