/*
 * @Author: truman
 * @Description:
 * @Date: 2021-12-29 10:04:27
 * @LastEditTime: 2021-12-29 10:33:24
 * @FilePath: \website\src\network\request.js
 */
import axios from 'axios'
import { Message } from 'element-ui'
import {} from 'element-ui'
import store from '@/store'
import { getToken } from '@/utils/auth'
axios.defaults.headers['Content-Type'] = 'application/json;charset=utf-8'
/**
 * 通过 vue.config.js,映射后端域名
 * 创建 axios 实例
 */
const service = axios.create({
  baseURL: '/api', // api base_url
  timeout: 50000 // 请求超时时间
})
// 响应拦截
service.interceptors.response.use(
  response => {
    const res = response.data
    if (res.code !== '200') {
      Message({
        message: res.message || 'Error',
        type: 'error',
        duration: 5 * 1000
      })
      return Promise.reject(new Error(res.msg || 'Error'))
    } else {
      return res
    }
  },
  error => {
    Message({
      message: error.message,
      type: 'error',
      duration: 5 * 1000
    })
    return Promise.reject(error)
  }
)

// todo 请求拦截,绑定用户令牌token。路由白名单。
service.interceptors.request.use(config => {
  // 请求接口时加载
  if (store.getters.token) {
    config.headers['Authorization'] = getToken() // 让每个请求携带自定义token，可根据实际情况修改。
    // config.headers['requestTime'] = getCurrenTimestampt() // 每次请求都带上当前时间戳，超过一定时间的接口不响应
  }
  return config
}, (error) => {
  return Promise.reject(error)
})

export {
  service as axios
}
