/*
 * @Author: truman
 * @Description:
 * @Date: 2021-12-29 10:04:27
 * @LastEditTime: 2021-12-29 10:33:24
 * @FilePath: \website\src\network\request.js
 */
import axios from 'axios'
import {
  MessageBox,
  Message
} from 'element-ui'
import {
} from 'element-ui'
import store from '@/store'
import { getToken } from '@/utils/auth'
axios.defaults.headers['Content-Type'] = 'application/json;charset=utf-8'
/**
 * 通过 vue.config.js,映射后端域名
 * 创建 axios 实例
 */
const service = axios.create({
  // baseURL: process.env.VUE_APP_BASE_API,
  baseURL: '/backend',
  timeout: 50000
})
// 响应拦截
service.interceptors.response.use(
  response => {
    const res = response.data
    // 内网穿透环境下，截取响应码为400或500时响应拦截
    // 接口响应后延时关闭加载
    if (parseInt(res.code) === 330) {
      Message({
        message: res.message || '登录失败！',
        type: 'error',
        duration: 5 * 1000
      })
      return Promise.reject(new Error(res.message || '登录失败'))
    } else if (parseInt(res.code) === 203) {
      // to re-login
      MessageBox.confirm('您的登录已失效，可以取消以留在此页面，或再次登录', '登录失效', {
        confirmButtonText: '重新登录',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(() => {
        store.dispatch('user/resetToken').then(() => {
          location.reload()
        })
      })
    } else if (parseInt(res.code) !== 200) {
      Message({
        message: res.message || '查询失败',
        type: 'error',
        duration: 5 * 1000
      })
      return Promise.reject(new Error(res.msg || '查询失败'))
    } else {
      return res
    }
  },
  error => {
    let status = null
    if (error.request) {
      status = error.request
    } else if (error.response) {
      status = error.response
    }
    if (status) {
      switch (status.status) {
        case 400:
          error.message = '(400)'
          break
        case 403:
          error.message = '(403)'
          break
        case 404:
          error.message = '(404)'
          break
        case 408:
          error.message = '(408)'
          break
        case 500:
          error.message = '(500)'
          break
        case 501:
          error.message = '(501)'
          break
        case 502:
          error.message = '(502)'
          break
        case 503:
          error.message = '(503)'
          break
        case 504:
          error.message = '(504)'
          break
        case 505:
          error.message = '(505)'
          break
        default:
          error.message = status.error
      }
    }
    Message({
      message: '服务器繁忙，请稍后重试！' + error.message,
      type: 'error',
      duration: 5 * 1000
    })
    return Promise.reject(error)
  }
)

// todo 请求拦截,绑定用户令牌token。路由白名单。
service.interceptors.request.use(config => {
  config.baseURL = import.meta.env.VITE_APP_BASE_API
  console.log(import.meta.env.VITE_APP_BASE_API)
  // 请求接口时加载
  if (store.getters.token) {
    config.headers['Authorization'] = getToken() // 让每个请求携带自定义token，可根据实际情况修改。
    config.headers['token'] = getToken()
    // config.headers['requestTime'] = getCurrenTimestampt() // 每次请求都带上当前时间戳，超过一定时间的接口不响应
  }
  return config
}, (error) => {
  return Promise.reject(error)
})
export {
  service as axios
}
