import { axios } from './request'
// post
function postAction(url, parameter) {
  return axios({
    url: url,
    method: 'post',
    data: parameter
  })
}

export function getAction(url, parameter) {
  return axios({
    url: url,
    method: 'get',
    params: parameter
  })
}
// 普通上传
const getFile = (params) => postAction('/wj/FilesUpload', params)

// 下载私有图片的地址
const getFileXz = (parameter) => getAction('/resource/down', parameter)

// 将上传的文件打包为后端接收的格式
// 如果传入了 上传方法 则返回执行后的返回值
const fileData = (file, fun) => {
  const formData = new FormData()
  console.log(file.file)
  formData.append('file', file.file)
  if (fun === null || fun === undefined || fun === '' || fun === 'null') {
    return formData
  } else {
    return fun(formData)
  }
}

export {
  getFile,
  getFileXz,
  fileData
}
