import { axios } from './request'
import { encryptDes } from '@/utils/rsaEncrypt'
import { getCasual } from '@/utils/auth'
// post
export function postEncryptAction(url, parameter) {
  return axios({
    url: url,
    method: 'post',
    data: encryptDes(parameter, getCasual())
  })
}

// post method= {post | put}
export function httpEncryptAction(url, parameter, method) {
  return axios({
    url: url,
    method: method,
    data: encryptDes(parameter, getCasual())
  })
}

// put
export function putEncryptAction(url, parameter) {
  return axios({
    url: url,
    method: 'put',
    data: encryptDes(parameter, getCasual())
  })
}

// get
export function getEncryptAction(url, parameter) {
  return axios({
    url: url,
    method: 'get',
    params: parameter
  })
}

// deleteAction
export function deleteEncryptAction(url, parameter) {
  return axios({
    url: url,
    method: 'delete',
    params: parameter
  })
}
