// eslint-disable-next-line no-unused-vars
import { getAction, postAction } from './manage'
import { encrypt } from '@/utils/rsaEncrypt'
// 登录
const Login = (params) => postAction('/yh/login', params)
// 注册
const Register = (params) => postAction('/yh/saveOrUpdateRbacYh', params)
// 注册
const sendMail = (mail, subject, content, isHtml = false) => postAction(`/mail/sendMail?mail=${mail}&subject=${subject}&content=${content}&isHtml=${isHtml}`, {})
// 获取用户信息
const GetInfo = (params) => getAction('/yh/getInfo', params)
// 重新获取Tokn
const ResetToken = (params) => postAction(import.meta.env.VITE_APP_SERVER_BASESYS + '/rbac/resetToken', params)
// 退出登录
const Logout = (params) => getAction('/yh/logout', params)

const getAnByQxbs = (params) => getAction(import.meta.env.VITE_APP_SERVER_BASESYS + '/rbac-an/getAnByQxbs', params)
export {
  Login,
  Register,
  sendMail,
  GetInfo,
  ResetToken,
  Logout,
  getAnByQxbs
}
