# websit

#### 华信前端框架-VUE

<p align="center">
  <a href="https://github.com/vuejs/vue">
    <img src="https://img.shields.io/badge/vue-2.6.10-brightgreen.svg" alt="vue">
  </a>
  <a href="https://github.com/ElemeFE/element">
    <img src="https://img.shields.io/badge/element--ui-2.7.0-brightgreen.svg" alt="element-ui">
  </a>
  <a href="https://travis-ci.org/PanJiaChen/vue-element-admin" rel="nofollow">
    <img src="https://travis-ci.org/PanJiaChen/vue-element-admin.svg?branch=master" alt="Build Status">
  </a>
  <a href="https://github.com/PanJiaChen/vue-element-admin/blob/master/LICENSE">
    <img src="https://img.shields.io/github/license/mashape/apistatus.svg" alt="license">
  </a>
  <a href="https://github.com/PanJiaChen/vue-element-admin/releases">
    <img src="https://img.shields.io/github/release/PanJiaChen/vue-element-admin.svg" alt="GitHub release">
  </a>
  <a href="https://gitter.im/vue-element-admin/discuss">
    <img src="https://badges.gitter.im/Join%20Chat.svg" alt="gitter">
  </a>
  <a href="https://panjiachen.github.io/vue-element-admin-site/donate">
    <img src="https://img.shields.io/badge/%24-donate-ff69b4.svg" alt="donate">
  </a>
</p>

#### 软件架构
软件架构说明

#### 下载项目

```
# clone 项目
git clone https://gitee.com/hnxzyszkj/website.git

# 进入项目文件夹下
cd website

# 安装依赖
npm install

# 本地开发
npm run dev

http://localhost:9528
```

#### 打包说明

```
# build for 测试环境
npm run build:stage

# build for 生产环境
npm run build:prod
```

#### Advanced

```
# preview the release environment effect
npm run preview

# preview the release environment effect + static resource analysis
npm run preview -- --report

# code format check
npm run lint

# code format check and auto fix
npm run lint -- --fix
```

#### 分析构建文件大小

​	如果您的构建文件很大，您可以通过使用`webpack-bundle-analyzer`.

```bash
npm run preview -- --report
```

​	运行后可以在http://localhost:9526/report.html看到具体的大小分布

![img](README.assets/3fddf034-2b38-4299-b0d2-b748fb2abef0.jpg)





#### 项目结构



​			

```bash
├── build                      # 打包配置文件
├── plop-templates             # 基础模板
├── public                     # 打包模板文件夹
│   │── favicon.ico            # 网站图标
│   └── index.html             # 打包html模板
├── src                        # main source文件夹
│   ├── network                # api接口文件夹
│   ├── assets                 # 静态资源文件夹  font\image等
│   ├── components             # 公共组件
│   ├── directive              # 公共指令
│   ├── filters                # 公共过滤器
│   ├── icons                  # 图标文件夹
│   ├── lang                   # i18n 
│   ├── layout                 # 公共布局文件夹
│   ├── router                 # 路由
│   ├── store                  # vuex
│   ├── styles                 # 公共样式
│   ├── utils                  # 公共Utils
│   ├── views                  # 主文件夹，所有开发的页面都存放在此处
│   ├── App.vue                # App.vue
│   ├── main.js                # 入口文件
│   └── permission.js          # 权限控制
├── tests                      # tests
├── .env.xxx                   # env variable configuration
├── .eslintrc.js               # eslint config
├── .babelrc                   # babel config
├── .travis.yml                # automated CI configuration
├── vue.config.js              # vue-cli config
├── postcss.config.js          # postcss config
└── package.json               # package.json
```



#### ESlint安装

##### 安装ESlint

​	![eslint1.png](README.assets/72f126cb-09eb-4b27-b02e-65e79eb76220.png)

##### VScode配置 依次点击 文件 > 首选项 > 设置 打开 VSCode 配置文件,添加如下配置

```json
 "files.autoSave": "off",
  "eslint.validate": [
    "javascript",
    "javascriptreact",
    "vue-html",
    {
      "language": "vue",
      "autoFix": true
    }
  ],
  "eslint.run": "onSave",
  "eslint.autoFixOnSave": true
```



##### 保存效果

![eslintGif.gif](README.assets/e94a76df-6dc0-4c15-9785-28b553a163e9.png)

​				**每次保存，vscode 就能标红不符合 eslint 规则的地方，同时还会做一些简单的自我修正**

#### Vue生态系统

​	**了解以下技术有助于您更好的阅读和开发本项目**

1. ##### [Vue Router](https://router.vuejs.org/) Vue Router 是 Vue.js 的官方路由器。它与 Vue.js 核心深度集成，使使用 Vue.js 构建单页应用程序变得轻而易举。

2. ##### [Vuex](https://vuex.vuejs.org/) Vuex 是 Vue.js 应用程序的状态管理模式 + 库。它充当应用程序中所有组件的集中存储，其规则确保状态只能以可预测的方式改变。

3. ##### [Vue 加载器](https://vue-loader.vuejs.org/)Vue-loader 是 webpack 的加载器，它允许您以称为单文件组件 (SFC) 的格式编写 Vue 组件。webpack 和 vue-loader 的组合为您提供了一个现代、灵活且极其强大的前端工作流程，用于创作 Vue.js 应用程序。

4. ##### [Vue 服务器渲染器](https://ssr.vuejs.org/)Vue-server-renderer 有助于构建同构或通用 JavaScript 应用程序，这些应用程序在服务器端和客户端运行，其中大部分应用程序代码被共享和重用。

5. ##### [Vue Test Utils](https://vue-test-utils.vuejs.org/) Vue Test Utils 是 Vue.js 的官方单元测试实用程序库。

6. ##### [Vue Dev-Tools](https://github.com/vuejs/vue-devtools)浏览器 devtools 扩展，用于调试 Vue.js 应用程序。

7. ##### [Vue CLI](https://cli.vuejs.org/) Vue CLI 是一个用于快速 Vue.js 开发的完整系统。它旨在成为 Vue 生态系统的标准工具基线。它确保各种构建工具与合理的默认值一起顺利工作，因此您可以专注于编写您的应用程序，而不是花费数天时间来处理配置。

8. ##### 用于 VS Code 的[Vetur](https://github.com/vuejs/vetur) Vue 工具。VS Code下写vue必备插件。